<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Jenssegers\Agent\Agent;
use Stevebauman\Location\Facades\Location;
use Illuminate\Support\Facades\Log;

class UltimateShield
{
    public function handle(Request $request, Closure $next)
    {
        $agent = new Agent();
        
        // FIX: Get the real IP from ngrok's forwarded header
        $ip = $request->header('X-Forwarded-For') ?? $request->ip();
        // $ip= '170.171.1.0';
        
        // ngrok often sends a list: "phone_ip, 127.0.0.1". We take the first one.
        if (str_contains($ip, ',')) {
            $ip = explode(',', $ip)[0];
            // $ip= '170.171.1.0';
        }
        $ip = trim($ip);
        // dd($ip);

        // 1. BOT CHECK
        if ($agent->isRobot()) {
            return $this->block($request, "BOT_DETECTED", $ip);
        }

        // 2. IP BLACKLIST
        $blockedIps = ['178.175.134.122', '104.244.210.60'];
        if (in_array($ip, $blockedIps)) {
            return $this->block($request, "IP_BLACKLISTED", $ip);
        }

        // 3. GEO-BLOCKING: Use the dynamic $ip variable here!
        $position = Location::get($ip); 
        // dd($position);  
        
        // If target is US, block everyone else
        if ($position && $position->countryCode !== 'US') {
            return $this->block($request, "GEO_BLOCKED_" . $position->countryCode, $ip);
        }

        // 4. CLOAKING: Access key check
        if ($request->query('visit') === '1') {
            session(['verified' => true]);
        }

        if (!session('verified')) {
            return $this->block($request, "NO_ACCESS_KEY", $ip);
        }

        return $next($request);
    }

    private function block($request, $reason, $ip) {
        Log::warning("Shield Blocked: [$reason] from IP: " . $ip);
        abort(404);
    }
}